package navigation;

import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.ArrayList;

public class IndexCube {
    private static final double DIAGONAL_CONST = Math.sqrt(3);
    private IndexCube[] cubes = null;
    private NavPoint navPoint = null;
    private Triple center;
    // size of the inner cube
    private double radius;
    
    public IndexCube(Triple center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public double getRadius() {
        return radius;
    }
    
    public ArrayList<NavPoint> getNavPointsNear(Triple location, double distance) {
        ArrayList<NavPoint> navPoints = new ArrayList();
        fillPointsNear(location, distance, navPoints);
        return navPoints;
    }
    
    public void insertNavPoint(NavPoint p) {
        if (navPoint == null && cubes == null) {
            navPoint = p;
        } else if (cubes == null) {
            cubes = new IndexCube[8];
            int cn = getCubeNumber(p.location);
            cubes[cn] = new IndexCube(p, getCenter(cn), radius/2);
            cn = getCubeNumber(navPoint.location);
            cubes[cn] = new IndexCube(navPoint, getCenter(cn), radius/2);    
            navPoint = null;
        } else {
            int cn = getCubeNumber(p.location);
            if (cubes[cn] == null) {
                cubes[cn] = new IndexCube(p, getCenter(cn), radius/2);
            } else {
                cubes[cn].insertNavPoint(p);
            }
        }
    }

    private IndexCube(NavPoint p, Triple center, double radius) {
        navPoint = p;
        this.center = center;
        this.radius = radius;
    }
    
    private void fillPointsNear(Triple location, double distance, ArrayList<NavPoint> navPoints) {
        if (navPoint != null && Triple.distanceInSpace(navPoint.location, location) <= distance) {
            navPoints.add(navPoint);
        }
        if (cubes == null) return;
        for (IndexCube c: cubes) {
            if (c != null) {
                if (Triple.distanceInSpace(c.center, location) < distance + radius*DIAGONAL_CONST) {
                    c.fillPointsNear(location, distance, navPoints);
                }
            }
        }
    }

    private Triple getCenter(int cn) {
        switch (cn) {
            case 0: return new Triple(center.x - radius/2, center.y - radius/2, center.z - radius/2);
            case 1: return new Triple(center.x - radius/2, center.y - radius/2, center.z + radius/2);
            case 2: return new Triple(center.x - radius/2, center.y + radius/2, center.z - radius/2);
            case 3: return new Triple(center.x - radius/2, center.y + radius/2, center.z + radius/2);
            case 4: return new Triple(center.x + radius/2, center.y - radius/2, center.z - radius/2);
            case 5: return new Triple(center.x + radius/2, center.y - radius/2, center.z + radius/2);
            case 6: return new Triple(center.x + radius/2, center.y + radius/2, center.z - radius/2);
            case 7: return new Triple(center.x + radius/2, center.y + radius/2, center.z + radius/2);
        }
        return null;
    }

    private int getCubeNumber(Triple location) {
        if (location.x < this.center.x) {
            if (location.y < this.center.y) {
                if (location.z < this.center.z) {
                    return 0;
                } else {
                    return 1;
                }
            } else {
                if (location.z < this.center.z) {
                    return 2;
                } else {
                    return 3;
                }
            }
        } else {
            if (location.y < this.center.y) {
                if (location.z < this.center.z) {
                    return 4;
                } else {
                    return 5;
                }
            } else {
                if (location.z < this.center.z) {
                    return 6;
                } else {
                    return 7;
                }
            }
        }
    }
}